# added option to message users via message box
namespace eval ::capFootprintViewer {
	# allow user option of Message Box as well as Session Log
	set bUseMessageBox 1
	set mLastPID ""
}

proc ::capFootprintViewer::GetPath { pString } {
	#convert "\" to "/"
	set ret [string map { \\ \/} $pString]
	return $ret
}

proc ::capFootprintViewer::MessageUser { pMessage pCaption } {
	if { $::capFootprintViewer::bUseMessageBox == 1 } {
		capDisplayMessageBox $pMessage $pCaption
	}
	::capFootprintViewer::DumpToSessionLog $pMessage
}

proc ::capFootprintViewer::GetFootprintFromSelectedObject { } {
	set lFootprint ""
	set lNullObj NULL
	set lSelectionlist [GetSelectedObjects]
	set lObject [lindex $lSelectionlist 0]
	if { [$lObject GetObjectType] == $::DboBaseObject_PLACED_INSTANCE } {
		set lParentSchematicOcc [GetInstanceOccurrence]
		if {$lParentSchematicOcc != $lNullObj} {
		    set lPropNameCStr [DboTclHelper_sMakeCString "PCB Footprint" 0]
			set lPropValueCStr [DboTclHelper_sMakeCStringAppOwned]
			set lobjOcc [$lObject GetObjectOccurrence $lParentSchematicOcc]
			if { $lobjOcc != $lNullObj } {
				$lobjOcc GetEffectivePropStringValue $lPropNameCStr $lPropValueCStr
			} else {
				$lObject GetEffectivePropStringValue $lPropNameCStr $lPropValueCStr
			}
			set lFootprint [DboTclHelper_sGetConstCharPtr $lPropValueCStr]
			DboTclHelper_sDeleteCString $lPropNameCStr
			DboTclHelper_sDeleteCString $lPropValueCStr
			if { [string compare $lFootprint ""] == 0 } {
				::capFootprintViewer::MessageUser "PCB Footprint property not found on this part" "No PCB Footprint"
				return $lFootprint
			}
		} else {
			::capFootprintViewer::MessageUser "Parent Schematic Occurence is NULL" "NULL Parent"
			return $lFootprint
		}
	} else {
		::capFootprintViewer::MessageUser "Selected object is not a Part" "Not a Part"
	}
	return $lFootprint
}

proc ::capFootprintViewer::ViewFootprint { } {
    set lAllegroFootprintSection "Allegro Footprints"

	set lFootprintStr [::capFootprintViewer::GetFootprintFromSelectedObject]
	if { [string compare $lFootprintStr ""] == 0 } {
		return 
	}
	
	package require inifile
	
	set lIniPath [GetIniPath]
	set lIniHandle [::ini::open $lIniPath r+]
	if { [::ini::exists $lIniHandle $lAllegroFootprintSection] == 1 } {
		set lkeylist [::ini::keys $lIniHandle $lAllegroFootprintSection]
		set lFile ""
		foreach lkey $lkeylist {
			set lPath [::ini::value $lIniHandle $lAllegroFootprintSection $lkey \"\"]
			set lPath [::capFootprintViewer::GetPath $lPath]
			set lExt ".dra"
			set lFilePath $lPath/$lFootprintStr$lExt
			if { [file exists $lFilePath] == 1 } {
				set lFile $lFilePath
				break
			}
		}
		if { [string compare $lFile ""] != 0 } {
			if { $::capFootprintViewer::mLastPID != "" } {
				catch {exec [auto_execok taskkill] /PID $::capFootprintViewer::mLastPID}
			}
			catch { set ::capFootprintViewer::mLastPID [exec allegro_free_viewer.exe $lFile &]} 	
		} else {
			::capFootprintViewer::MessageUser "Footprint $lFootprintStr does not exist in path specified in section $lAllegroFootprintSection, please check" "Footprint not found"
		}
	} else {
			::capFootprintViewer::MessageUser "Allegro Footprints section does not exists in ini $lIniPath, Please configure it" "No Allegro Footprints section"
	}
	::ini::close $lIniHandle
}

proc ::capFootprintViewer::DumpToSessionLog { pMsg } {
	set lStr [DboTclHelper_sMakeCString $pMsg 0]
	DboState_WriteToSessionLog $lStr
	DboTclHelper_sDeleteCString $lStr
	unset lStr
} 

proc ::capFootprintViewer::shouldProcess { args } {
    set lSelectionlist [GetSelectedObjects]
	if { [llength $lSelectionlist] != 1 } {
		return 0
	} else {
		return 1
	}
}

RegisterAction "View Footprint"   "::capFootprintViewer::shouldProcess" "Alt+F" "::capFootprintViewer::ViewFootprint" "SCHEMATIC"